/*
 * Decompiled with CFR 0.152.
 */
package pse.pt;

import apicore.ptmp.OptionsManager;
import apicore.ptmp.PTSessionClosedError;
import apicore.ptmp.PacketTracerSession;
import apicore.ptmp.PacketTracerSessionFactory;
import apicore.util.Pair;
import apiipc.generated.IPCFactory;
import apiipc.generated.enums.CommandStatus;
import apiipc.generated.enums.TimerType;
import apiipc.generated.sim.CiscoDevice;
import apiipc.generated.sim.Device;
import apiipc.generated.sim.Network;
import apiipc.generated.system.ActivityFile;
import apiipc.generated.system.ActivityScriptEngine;
import apiipc.generated.system.AssessmentModelScriptInterface;
import apiipc.generated.system.CommandLog;
import apiipc.generated.system.CommandLogEntry;
import apiipc.generated.system.NetworkFile;
import apiipc.generated.system.ScriptValue;
import apiipc.generated.ui.ActivityWizard;
import apiipc.generated.ui.AdministrativeDialog;
import apiipc.generated.ui.AppWindow;
import apiipc.generated.ui.IPC;
import apiipc.generated.ui.InstructionDlg;
import apiipc.generated.ui.LogicalWorkspace;
import apiipc.generated.ui.MenuBar;
import apiipc.generated.ui.PopupMenu;
import apiipc.generated.ui.ToolBar;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import pse.pt.PacketTracerLauncher;
import pse.result.IosCommandEntry;
import pse.result.IosLog;
import pse.result.IosLogEntry;
import pse.util.general.ApplicationError;
import pse.util.general.PacketTracerProgress;
import pse.util.general.PacketTracerProgressHandler;
import pse.util.general.ProcessReadThread;
import pse.util.general.ThreadUtils;
import pse.util.general.Utilities;
import pse.util.general.XmlUtils;
import skeletonapplet.PacketTracerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketTracer {
    protected String hostName;
    protected int ipcPort;
    protected boolean noGui;
    protected ProcessReadThread readThread;
    protected Process packetTracerProcess;
    protected PacketTracerSession packetTracerSession;
    protected IPCFactory ipcFactory;
    protected String version;
    public static boolean USE_CONNECTIVITY_TEST_EVALUATION = false;

    public PacketTracer() {
        this("localhost", 39000, false);
    }

    public PacketTracer(String string, int n, boolean bl) {
        this.hostName = string;
        this.ipcPort = n;
        this.noGui = bl;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.ipcPort;
    }

    public Process getPacketTracerProcess() {
        return this.packetTracerProcess;
    }

    public PacketTracerSession getPacketTracerSession() {
        return this.packetTracerSession;
    }

    public PacketTracerSession connectImmediately() {
        try {
            OptionsManager optionsManager = OptionsManager.getInstance("pep/pep.properties");
            PacketTracerSessionFactory packetTracerSessionFactory = PacketTracerSessionFactory.getInstance();
            this.packetTracerSession = packetTracerSessionFactory.openSession(this.hostName, this.ipcPort, null);
            this.ipcFactory = new IPCFactory(this.packetTracerSession);
        }
        catch (Throwable throwable) {
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
        return this.packetTracerSession;
    }

    public PacketTracerSession connect() {
        return this.connect(1000, 60000);
    }

    public PacketTracerSession connect(int n, int n2) {
        long l = System.currentTimeMillis();
        boolean bl = false;
        OptionsManager optionsManager = OptionsManager.getInstance("pep/pep.properties");
        while (!bl) {
            try {
                PacketTracerSessionFactory packetTracerSessionFactory = PacketTracerSessionFactory.getInstance();
                this.packetTracerSession = packetTracerSessionFactory.openSession(this.hostName, this.ipcPort, null);
                this.ipcFactory = new IPCFactory(this.packetTracerSession);
                bl = this.packetTracerSession.isConnected();
            }
            catch (ConnectException connectException) {
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            long l2 = System.currentTimeMillis() - l;
            if (l2 >= (long)n2) {
                throw new ApplicationError.PacketTracerConnectTimeOut();
            }
            Utilities.guaranteedSleep(n);
        }
        return this.packetTracerSession;
    }

    public Process launch() {
        return this.launch(new PacketTracerLocator());
    }

    public Process launch(PacketTracerLocator packetTracerLocator) {
        return this.launch(new PacketTracerLauncher(packetTracerLocator));
    }

    public Process launch(PacketTracerLauncher packetTracerLauncher) {
        try {
            this.packetTracerProcess = packetTracerLauncher.launch(this.ipcPort, this.noGui);
            this.readThread = new ProcessReadThread(this.packetTracerProcess);
            this.readThread.setDaemon(true);
            this.readThread.start();
        }
        catch (Throwable throwable) {
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.PacketTracerLaunch(throwable);
        }
        return this.packetTracerProcess;
    }

    public boolean isAlive() {
        try {
            return this.packetTracerSession.isOpen();
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            return false;
        }
    }

    public boolean isUp() {
        try {
            return this.packetTracerSession.isUp();
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            return false;
        }
    }

    public boolean testIfUp() {
        try {
            this.packetTracerSession.testWrite();
            return this.packetTracerSession.isUp();
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
            return false;
        }
    }

    public void setCountUp(long l) {
        try {
            ActivityFile activityFile = this.getActivityFile();
            activityFile.setCountDownTime((int)l + 360000);
            activityFile.setTimerType(TimerType.LAPSED);
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkSwallow(throwable);
        }
    }

    public int getTimeLeft() {
        try {
            ActivityFile activityFile = this.getActivityFile();
            return activityFile.getCountDownTime();
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkSwallow(throwable);
            return -1;
        }
    }

    public void setTimeLeft(long l) {
        try {
            ActivityFile activityFile = this.getActivityFile();
            activityFile.setCountDownTime((int)l);
            activityFile.setTimerType(TimerType.COUNTDOWN);
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkSwallow(throwable);
        }
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        try {
            this.version = this.getAppWindow().getVersion();
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.check(throwable);
        }
        return this.version;
    }

    public int getMajorVersion() {
        this.getVersion();
        int n = this.version.indexOf(".");
        String string = this.version.substring(0, n);
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return 0;
        }
    }

    public int getMinorVersion() {
        this.getVersion();
        int n = this.version.indexOf(".");
        int n2 = this.version.indexOf(".", n + 1);
        String string = this.version.substring(n + 1, n2);
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return 0;
        }
    }

    public int getBuild() {
        this.getVersion();
        int n = this.version.indexOf(".");
        n = this.version.indexOf(".", n + 1);
        String string = this.version.substring(n + 1);
        try {
            return Integer.parseInt(string);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
            return 0;
        }
    }

    public byte[] extractBytes() {
        List<Byte> list = this.extractByteList();
        byte[] byArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            byArray[i] = list.get(i);
        }
        return byArray;
    }

    public List<Byte> extractByteList() {
        try {
            return this.getAppWindow().fileSaveToBytes();
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
    }

    public boolean loadByteList(List<Byte> list, String string) {
        try {
            return this.getAppWindow().fileOpenFromBytes(list, string);
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
    }

    public boolean loadBytes(byte[] byArray, String string) {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            arrayList.add(byArray[i]);
        }
        return this.loadByteList(arrayList, string);
    }

    public boolean loadByteListViaTempFile(List<Byte> list) {
        try {
            File file = File.createTempFile("pta", "pka");
            byte[] byArray = new byte[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                byArray[i] = list.get(i);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
            ((OutputStream)fileOutputStream).close();
            return this.fileOpen(file.getCanonicalPath());
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
    }

    public boolean fileOpen(String string) {
        try {
            return this.getAppWindow().fileOpen(string);
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
    }

    public boolean saveActivity(String string) {
        try {
            return this.getAppWindow().fileSaveAs(string);
        }
        catch (Throwable throwable) {
            this.check(throwable);
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
    }

    public IPCFactory getIpcFactory() {
        return this.ipcFactory;
    }

    public LogicalWorkspace getLogicalWorkspace() {
        return this.getAppWindow().getActiveWorkspace().getLogicalWorkspace();
    }

    public AppWindow getAppWindow() {
        IPC iPC = this.ipcFactory.getIPC();
        AppWindow appWindow = iPC.appWindow();
        return appWindow;
    }

    public IosLog getIosLog() {
        return this.getIosLog(new PacketTracerProgressHandler());
    }

    public IosLog getIosLog(PacketTracerProgress packetTracerProgress) {
        IosLog iosLog = new IosLog();
        return this.getIosLog(packetTracerProgress, iosLog);
    }

    public IosLog getIosLog(IosLog iosLog) {
        return this.getIosLog(new PacketTracerProgressHandler(), iosLog);
    }

    public IosLog getIosLog(PacketTracerProgress packetTracerProgress, IosLog iosLog) {
        Object object;
        Object object2;
        IosLog iosLog2 = new IosLog();
        if (iosLog != null && iosLog.getEntries() != null) {
            object2 = iosLog.getEntries().iterator();
            while (object2.hasNext()) {
                object = (IosLogEntry)object2.next();
                iosLog2.addEntry((IosLogEntry)object);
            }
        }
        if ((object2 = this.getLogContents(packetTracerProgress)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                CommandLogEntry commandLogEntry = (CommandLogEntry)object.next();
                IosCommandEntry iosCommandEntry = new IosCommandEntry();
                iosCommandEntry.setDevice(commandLogEntry.getDeviceName());
                iosCommandEntry.setDeviceTime(commandLogEntry.getTimeToString());
                iosCommandEntry.setPrompt(commandLogEntry.getPrompt());
                iosCommandEntry.setCommand(commandLogEntry.getCommand());
                iosLog2.addEntry(iosCommandEntry);
            }
        }
        return iosLog2;
    }

    public CommandLog getCommandLog() {
        return this.ipcFactory.getIPC().commandLog();
    }

    public Network getNetwork() {
        return this.ipcFactory.getIPC().network();
    }

    public ActivityFile getActivityFile() {
        AppWindow appWindow = this.getAppWindow();
        NetworkFile networkFile = appWindow.getActiveFile();
        return (ActivityFile)networkFile;
    }

    public boolean isPka() {
        NetworkFile networkFile = this.getAppWindow().getActiveFile();
        return networkFile != null && networkFile instanceof ActivityFile;
    }

    public List<Device> getAllDevices() {
        Network network = this.getNetwork();
        ArrayList<Device> arrayList = new ArrayList<Device>();
        int n = network.getDeviceCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(network.getDeviceAt(i));
        }
        return arrayList;
    }

    public String getRunningConfig(String string) {
        CiscoDevice ciscoDevice = (CiscoDevice)this.getNetwork().getDevice(string);
        this.executeCommand(ciscoDevice, "enable", "user");
        return this.executeCommand(ciscoDevice, "show run", "enable");
    }

    protected String executeCommand(String string, String string2, String string3) {
        CiscoDevice ciscoDevice = (CiscoDevice)this.getNetwork().getDevice(string);
        return this.executeCommand(ciscoDevice, string2, string3);
    }

    protected String executeCommand(CiscoDevice ciscoDevice, String string, String string2) {
        Pair<CommandStatus, String> pair = ciscoDevice.enterCommand(string, string2);
        return pair.getSecond();
    }

    public List<CommandLogEntry> getLogContents(PacketTracerProgress packetTracerProgress) {
        ArrayList<CommandLogEntry> arrayList = new ArrayList<CommandLogEntry>();
        try {
            CommandLog commandLog = this.getCommandLog();
            int n = commandLog.getEntryCount();
            packetTracerProgress.startWorkProductExtractionLog(n);
            for (int i = 0; i < n; ++i) {
                CommandLogEntry commandLogEntry = commandLog.getEntryAt(i);
                arrayList.add(commandLogEntry);
                packetTracerProgress.inProcessWorkProductExtractionLog(i + 1);
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        packetTracerProgress.finishWorkProductExtractionLog();
        return arrayList;
    }

    public ActivityScriptEngine getActivityScriptEngine() {
        ActivityFile activityFile = this.getActivityFile();
        ActivityScriptEngine activityScriptEngine = activityFile.getActivityScriptEngine();
        return activityScriptEngine;
    }

    public AssessmentModelScriptInterface getAssessmentModelScriptInterface() {
        ActivityFile activityFile = this.getActivityFile();
        ActivityScriptEngine activityScriptEngine = activityFile.getActivityScriptEngine();
        AssessmentModelScriptInterface assessmentModelScriptInterface = activityScriptEngine.getAssessmentModelScriptInterface();
        return assessmentModelScriptInterface;
    }

    public boolean evaluateScriptEngine() {
        if (USE_CONNECTIVITY_TEST_EVALUATION) {
            return this.evaluateScriptEngineConnectivityTests();
        }
        return this.evaluateScriptEngineNoConnectivityTests();
    }

    public boolean evaluateScriptEngineConnectivityTests() {
        ScriptValue scriptValue;
        AppWindow appWindow = this.getAppWindow();
        InstructionDlg instructionDlg = appWindow.getInstructionDlg();
        ActivityScriptEngine activityScriptEngine = this.getActivityScriptEngine();
        try {
            instructionDlg.setDisabled(false);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        try {
            instructionDlg.setWidgetDisable("resetBtn", false);
            instructionDlg.setWidgetDisable("checkAnswerBtn", false);
            instructionDlg.setWidgetDisable("progressLbl", false);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        try {
            appWindow.setVisible(false);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        try {
            instructionDlg.setVisible(false);
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        instructionDlg.showAnswerPage(false);
        try {
            scriptValue = activityScriptEngine.evaluate("PROFICIENCY_MODEL.getLog()", "GET");
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        try {
            scriptValue = activityScriptEngine.evaluate("PROFICIENCY_MODEL.getOverallReport()", "GET");
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        return true;
    }

    public boolean evaluateScriptEngineNoConnectivityTests() {
        ScriptValue scriptValue;
        ActivityScriptEngine activityScriptEngine = this.getActivityScriptEngine();
        ScriptValue scriptValue2 = activityScriptEngine.evaluate("PROFICIENCY_MODEL.evaluateModel()", "GET");
        try {
            scriptValue = activityScriptEngine.evaluate("PROFICIENCY_MODEL.getLog()", "GET");
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        try {
            scriptValue = activityScriptEngine.evaluate("PROFICIENCY_MODEL.getOverallReport()", "GET");
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        return scriptValue2 == null || !scriptValue2.isError();
    }

    public String getProficiencyModelXml() {
        ActivityScriptEngine activityScriptEngine = this.getActivityScriptEngine();
        String string = activityScriptEngine.evaluate("PROFICIENCY_MODEL.toXML();", "GET").toString();
        return XmlUtils.escapeLowCharacters(string);
    }

    public ScriptValue getScriptValue(ActivityScriptEngine activityScriptEngine, String string) {
        return activityScriptEngine.evaluate("return " + string, "GET");
    }

    public String getAnswerNetworkValue(AssessmentModelScriptInterface assessmentModelScriptInterface, String string) {
        return assessmentModelScriptInterface.getAssessmentItemValue("answer", string);
    }

    public String getUserNetworkValue(AssessmentModelScriptInterface assessmentModelScriptInterface, String string) {
        return assessmentModelScriptInterface.getAssessmentItemValue("user", string);
    }

    public void enableInterface() {
        this.toggleInterface(false);
    }

    public void disableInterface() {
        this.toggleInterface(true);
    }

    public void enableClose() {
        try {
            this.getAppWindow().setPreventClose(false);
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
    }

    protected void toggleInterface(boolean bl) {
        boolean bl2 = !bl;
        try {
            AppWindow appWindow = this.getAppWindow();
            try {
                appWindow.setPreventClose(true);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getActiveDialog().setDisable(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getActivityWizard().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getAdminDialog().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getCommonToolbar().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getInfoDialog().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getInstructionDlg().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getLogicalToolbar().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getNetworkComponentBox().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getPaletteDialog().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getPDUListWindow().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getPLSwitch().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getPhysicalLocationDialog().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getPhysicalToolbar().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getRSSwitch().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getRealtimeToolbar().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getSimulationPanel().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getSimulationToolbar().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                appWindow.getUserCreatedPDU().setDisabled(bl);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            MenuBar menuBar = appWindow.getMenuBar();
            PopupMenu popupMenu = menuBar.getFilePopupMenu();
            PopupMenu popupMenu2 = menuBar.getEditPopupMenu();
            PopupMenu popupMenu3 = menuBar.getOptionsPopupMenu();
            PopupMenu popupMenu4 = menuBar.getExtensionsPopupMenu();
            PopupMenu popupMenu5 = menuBar.getHelpPopupMenu();
            popupMenu.setItemEnabled("New", bl2);
            popupMenu.setItemEnabled("Open", bl2);
            popupMenu.setItemEnabled("Open Samples", bl2);
            popupMenu.setItemEnabled("Save", bl2);
            popupMenu.setItemEnabled("Save As", bl2);
            popupMenu.setItemEnabled("Save As Pkz", bl2);
            popupMenu.setItemEnabled("Print", bl2);
            popupMenu.setItemEnabled("Recent Files", bl2);
            popupMenu.setItemEnabled("Exit", bl2);
            popupMenu2.setItemEnabled("Copy", bl2);
            popupMenu2.setItemEnabled("Paste", bl2);
            popupMenu2.setItemEnabled("Undo", bl2);
            popupMenu3.setItemEnabled("Preferences", bl2);
            popupMenu3.setItemEnabled("User Profile", bl2);
            popupMenu3.setItemEnabled("Algorithm Settings", bl2);
            popupMenu4.setItemEnabled("Activity Wizard", bl2);
            popupMenu4.setItemEnabled("Multiuser", bl2);
            popupMenu4.setItemEnabled("IPC", bl2);
            popupMenu4.setItemEnabled("UPnP Multiuser", bl2);
            popupMenu5.setItemEnabled("Contents", bl2);
            popupMenu5.setItemEnabled("Tutorials", bl2);
            popupMenu5.setItemEnabled("About", bl2);
            ToolBar toolBar = appWindow.getToolBar();
            toolBar.setItemEnabled("New", bl2);
            toolBar.setItemEnabled("Open", bl2);
            toolBar.setItemEnabled("Save", bl2);
            toolBar.setItemEnabled("Print", bl2);
            toolBar.setItemEnabled("Activity Wizard", bl2);
            toolBar.setItemEnabled("Copy", bl2);
            toolBar.setItemEnabled("Paste", bl2);
            toolBar.setItemEnabled("Undo", bl2);
            toolBar.setItemEnabled("Custom Devices Dialog", bl2);
        }
        catch (Throwable throwable) {
            Utilities.checkIgnore(throwable);
            throw new ApplicationError.IpcError(throwable);
        }
    }

    public void customizeInterfaceForSummativeExam() {
        boolean bl = false;
        while (!bl) {
            try {
                this.getAppWindow().getInstructionDlg().setVisible(true);
                bl = true;
                Utilities.guaranteedSleep(500L);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        try {
            AppWindow appWindow = this.getAppWindow();
            ActivityWizard activityWizard = appWindow.getActivityWizard();
            ToolBar toolBar = appWindow.getToolBar();
            AdministrativeDialog administrativeDialog = appWindow.getAdminDialog();
            InstructionDlg instructionDlg = appWindow.getInstructionDlg();
            ActivityFile activityFile = this.getActivityFile();
            MenuBar menuBar = appWindow.getMenuBar();
            PopupMenu popupMenu = menuBar.getFilePopupMenu();
            PopupMenu popupMenu2 = menuBar.getEditPopupMenu();
            PopupMenu popupMenu3 = menuBar.getOptionsPopupMenu();
            PopupMenu popupMenu4 = menuBar.getExtensionsPopupMenu();
            PopupMenu popupMenu5 = menuBar.getHelpPopupMenu();
            try {
                appWindow.setPreventClose(true);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                activityWizard.setVisible(false);
                activityWizard.setDisabled(true);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            try {
                administrativeDialog.setVisible(false);
                administrativeDialog.setDisabled(true);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
            instructionDlg.setEditInstructionsLocked(true);
            instructionDlg.setWidgetDisable("resetBtn", true);
            instructionDlg.setWidgetDisable("checkAnswerBtn", true);
            instructionDlg.setWidgetDisable("progressLbl", true);
            popupMenu.setItemEnabled("New", false);
            popupMenu.setItemEnabled("Open", false);
            popupMenu.setItemEnabled("Open Samples", false);
            popupMenu.setItemEnabled("Save", false);
            popupMenu.setItemEnabled("Save As", false);
            popupMenu.setItemEnabled("Save As Pkz", false);
            popupMenu.setItemEnabled("Print", true);
            popupMenu.setItemEnabled("Recent Files", false);
            popupMenu.setItemEnabled("Exit", false);
            popupMenu2.setItemEnabled("Copy", false);
            popupMenu2.setItemEnabled("Paste", false);
            popupMenu2.setItemEnabled("Undo", true);
            popupMenu3.setItemEnabled("Preferences", false);
            popupMenu3.setItemEnabled("User Profile", false);
            popupMenu3.setItemEnabled("Algorithm Settings", false);
            popupMenu4.setItemEnabled("Activity Wizard", false);
            popupMenu4.setItemEnabled("Multiuser", false);
            popupMenu4.setItemEnabled("IPC", false);
            popupMenu4.setItemEnabled("UPnP Multiuser", false);
            popupMenu5.setItemEnabled("Contents", true);
            popupMenu5.setItemEnabled("Tutorials", true);
            popupMenu5.setItemEnabled("About", true);
            activityFile.setDynamicPF(false);
            toolBar.setItemEnabled("New", false);
            toolBar.setItemEnabled("Open", false);
            toolBar.setItemEnabled("Save", false);
            toolBar.setItemEnabled("Print", true);
            toolBar.setItemEnabled("Activity Wizard", false);
            toolBar.setItemEnabled("Copy", false);
            toolBar.setItemEnabled("Paste", false);
            toolBar.setItemEnabled("Undo", true);
            toolBar.setItemEnabled("Custom Devices Dialog", false);
            try {
                this.getCommandLog().setEnabled(true);
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
    }

    public void shutDown() {
        if (USE_CONNECTIVITY_TEST_EVALUATION) {
            // empty if block
        }
        if (this.ipcFactory != null) {
            try {
                try {
                    this.getAppWindow().setPreventClose(false);
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                }
                try {
                    this.getAppWindow().exitNoConfirm(true);
                }
                catch (Throwable throwable) {
                    Utilities.check(throwable);
                    this.getAppWindow().exit();
                }
                this.ipcFactory = null;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        if (this.packetTracerSession != null) {
            try {
                this.packetTracerSession.close();
                this.packetTracerSession = null;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        if (this.readThread != null) {
            try {
                this.readThread.beDone();
                this.readThread = null;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        this.closePacketTracerProcess();
    }

    public void shutDownNoIpc() {
        if (this.packetTracerSession != null) {
            try {
                this.packetTracerSession.close();
                this.packetTracerSession = null;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        if (this.readThread != null) {
            try {
                this.readThread.beDone();
                this.readThread = null;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
        this.closePacketTracerProcess();
    }

    public void shutDownSession() {
        if (this.packetTracerSession != null) {
            try {
                this.packetTracerSession.close();
                this.packetTracerSession = null;
            }
            catch (Throwable throwable) {
                Utilities.check(throwable);
            }
        }
    }

    protected void check(Throwable throwable) {
        if (throwable instanceof PTSessionClosedError) {
            throw (PTSessionClosedError)throwable;
        }
    }

    protected boolean checkPacketTracerProcessExit() {
        try {
            int n = this.packetTracerProcess.exitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    protected void closePacketTracerProcess() {
        if (this.packetTracerProcess != null) {
            boolean bl = false;
            int n = 0;
            while (!bl) {
                boolean bl2 = this.checkPacketTracerProcessExit();
                if (bl2 || n > 40) {
                    bl = true;
                    continue;
                }
                ThreadUtils.guaranteedSleep(1000L);
                ++n;
            }
            this.packetTracerProcess.destroy();
        }
    }

    protected String mungeName(String string) {
        int n;
        String string2 = string;
        String string3 = "";
        int n2 = 0;
        int n3 = string.lastIndexOf(".");
        if (n3 >= 0) {
            string2 = string.substring(0, n3);
            string3 = string.substring(n3);
        }
        if ((n = string2.lastIndexOf("-")) >= 0 && this.allDigits(string2.substring(n + 1))) {
            string2 = string2.substring(0, n);
            try {
                n2 = Integer.parseInt(string2.substring(n + 1));
            }
            catch (Throwable throwable) {
                n2 = 0;
            }
        }
        int n4 = n2 + 1;
        boolean bl = true;
        String string4 = null;
        while (bl) {
            string4 = string2 + "-";
            if (n4 < 10) {
                string4 = string4 + "00";
            } else if (n4 < 100) {
                string4 = string4 + "0";
            }
            string4 = string4 + n4;
            string4 = string4 + string3;
            File file = new File(string4);
            bl = file.exists();
            ++n4;
        }
        return string4;
    }

    protected boolean allDigits(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void useConnectivityTestEvaluation(boolean bl) {
        USE_CONNECTIVITY_TEST_EVALUATION = bl;
    }

    public static int findOpenIpcPort() {
        return PacketTracer.findOpenIpcPort(39000);
    }

    public static int findOpenIpcPort(int n) {
        return PacketTracer.findOpenIpcPort(n, 65000);
    }

    public static int findOpenIpcPort(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            if (!PacketTracer.isOpenPort(i)) continue;
            return i;
        }
        return -1;
    }

    protected static boolean isOpenPort(int n) {
        Socket socket = null;
        boolean bl = false;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress("localhost", n), 1000);
        }
        catch (BindException bindException) {
            bl = true;
        }
        catch (ConnectException connectException) {
            bl = true;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            bl = true;
        }
        catch (Throwable throwable) {
            Utilities.checkSwallow(throwable);
        }
        try {
            socket.close();
        }
        catch (Throwable throwable) {
            Utilities.check(throwable);
        }
        return bl;
    }
}

